<ResourceDictionary xmlns="http://namespace.square-enix.com/sqwt" xmlns:x="http://namespace.square-enix.com/sqwt/x">
  <ControlTemplate TargetType="{x:Type Window}" x:Key="WindowTemplate">
    <Grid Name="Grid_01" Margin="4">
      <ContentPresenter ClipToBounds="False" />
    </Grid>
    <Setter Property="SqwtTopOffset" Value="5" />
    <Setter Property="SqwtLeftOffset" Value="5" />
    <ControlTemplate.Triggers>
      <EventTrigger RoutedEvent="Shown" Name="WindowOpen">
        <BeginStoryboard>
          <Storyboard>
            <PropertyAnimationUsingKeyFrames Storyboard.TargetProperty="RenderTransformOrigin">
              <DiscreteValueKeyFrame Value="0.5,0.5" />
            </PropertyAnimationUsingKeyFrames>
            <DoubleAnimation From="0" To="1" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="VisualOpacity" />
            <DoubleAnimation To="0" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="SqwtTopOffset" />
            <DoubleAnimation To="0" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="SqwtLeftOffset" />
          </Storyboard>
        </BeginStoryboard>
      </EventTrigger>
      <EventTrigger RoutedEvent="Closing" Name="WindowClose">
        <BeginStoryboard>
          <Storyboard CompletedCommand="ApplicationCommands.DestroyWindow">
            <PropertyAnimationUsingKeyFrames Storyboard.TargetProperty="RenderTransformOrigin">
              <DiscreteValueKeyFrame Value="0.5,0.5" />
            </PropertyAnimationUsingKeyFrames>
            <DoubleAnimation From="1" To="0" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="VisualOpacity" />
            <DoubleAnimation To="5" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="SqwtTopOffset" />
            <DoubleAnimation To="5" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="SqwtLeftOffset" />
          </Storyboard>
        </BeginStoryboard>
      </EventTrigger>
      <EventTrigger RoutedEvent="Hiding" Name="WindowHide">
        <BeginStoryboard>
          <Storyboard CompletedCommand="ApplicationCommands.InvisibleWindow">
            <PropertyAnimationUsingKeyFrames Storyboard.TargetProperty="RenderTransformOrigin">
              <DiscreteValueKeyFrame Value="0.5,0.5" />
            </PropertyAnimationUsingKeyFrames>
            <DoubleAnimation From="1" To="0" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="VisualOpacity" />
            <DoubleAnimation To="5" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="SqwtTopOffset" />
            <DoubleAnimation To="5" Duration="0:0:0.2" BeginTime="0:0:0" Storyboard.TargetProperty="SqwtLeftOffset" />
          </Storyboard>
        </BeginStoryboard>
      </EventTrigger>
    </ControlTemplate.Triggers>
  </ControlTemplate>
</ResourceDictionary>